<?php
/**
 * Child Theme Header
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <?php wp_head(); ?>
  <style>
    /* --- HEADER BASE STYLES --- */
    header.site-header {
      position: fixed;
      top: 0; left: 0; right: 0;
      background-color: black;
      border-bottom: 1px solid white;
      padding: 20px 30px;
      z-index: 9999;
      display: flex;
      justify-content: center;
      margin: 0 !important;
      box-sizing: border-box;
      width: 100%;
      height: 80px;
    }
    .header-inner {
      max-width: 1400px;
      width: 100%;
      display: flex;
      justify-content: space-between;
      align-items: center;
      box-sizing: border-box;
    }
    .logo img {
      height: 45px;
      max-width: 100%;
      transition: height 0.3s ease;
    }

    /* --- MENU BUTTON --- */
    .dropdown {
      position: relative;
      font-family: 'Arial', sans-serif;
    }
    .menu-btn {
      width: 30px;
      height: 22px;
      background: none;
      border: none;
      cursor: pointer;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      padding: 0;
    }
    .menu-btn span {
      display: block;
      height: 4px;
      width: 30px;
      background-color: white;
      border-radius: 2px;
      transition: all 0.3s ease;
      box-shadow: 0 0 6px 2px rgba(255,255,255,0.7);
    }

    /* --- DROPDOWN MENU --- */
    .dropdown-content {
      display: none;
      position: absolute;
      right: 0;
      top: 100%;
      margin-top: 10px;
      background: linear-gradient(145deg, #1c1c1c, #000000);
      min-width: 220px;
      border: 2px solid #D99F22;
      border-radius: 8px;
      box-shadow: 0 8px 20px rgba(217,159,34,0.6);
      z-index: 10001;
      padding: 10px 0;
      font-weight: 600;
      font-size: 16px;
      transition: opacity 0.35s ease, transform 0.35s ease;
      opacity: 0;
      transform: translateY(-15px);
      pointer-events: none;
      box-sizing: border-box;
    }
    .dropdown.show .dropdown-content {
      display: block;
      opacity: 1;
      transform: translateY(0);
      pointer-events: auto;
    }
    .dropdown-content a {
      color: #D99F22;
      padding: 15px 25px;
      text-decoration: none;
      display: flex;
      align-items: center;
      font-style: normal;
      font-size: 18px;
      letter-spacing: 0.03em;
      transition: background-color 0.3s ease, color 0.3s ease;
      box-sizing: border-box;
    }
    .dropdown-content a:hover {
      background-color: #D99F22;
      color: black;
      border-radius: 5px;
    }

    /* --- SUBMENU --- */
    .submenu {
      display: flex;
      flex-direction: column;
    }
    .submenu-btn {
      background: none;
      border: none;
      color: #D99F22;
      text-align: left;
      padding: 15px 25px;
      font-size: 18px;
      font-weight: 600;
      letter-spacing: 0.03em;
      cursor: pointer;
    }
    .submenu-btn:hover {
      background-color: #D99F22;
      color: black;
      border-radius: 5px;
    }
    .submenu-content {
      display: none;
      flex-direction: column;
    }
    .submenu.show .submenu-content {
      display: flex;
    }
    .submenu-content a {
      padding-left: 40px; /* indent social links */
      font-size: 16px;
    }

    /* --- RESPONSIVE FOR MOBILE --- */
    @media (max-width: 480px) {
      header.site-header {
        padding: 15px 20px;
        height: 65px;
      }
      .header-inner {
        max-width: 100%;
        padding: 0 10px;
      }
      .menu-btn {
        width: 35px;
        height: 25px;
      }
      .menu-btn span {
        width: 25px;
        height: 4px;
      }
      .logo img {
        height: 40px;
      }
    }

    /* --- PREVENT HORIZONTAL SCROLL --- */
    html, body {
      overflow-x: hidden;
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    body {
      padding-top: 65px;
      background-color: white;
      box-sizing: border-box;
    }
    @media (min-width: 481px) {
      body {
        padding-top: 80px;
      }
    }
  </style>
</head>
<body <?php body_class(); ?>>

<header class="site-header" role="banner">
  <div class="header-inner">
    <a href="<?php echo esc_url(home_url('/')); ?>" class="logo" aria-label="Home">
      <img src="https://take5nutrition.com/wp-content/uploads/2024/12/cropped-cropped-IMG_0815.png" alt="Take 5 Nutrition Logo" />
    </a>
    <div class="dropdown" id="dropdown">
      <button class="menu-btn" aria-haspopup="true" aria-expanded="false" aria-controls="menu-list" id="menu-btn" aria-label="Toggle menu">
        <span></span>
        <span></span>
        <span></span>
      </button>
      <nav class="dropdown-content" id="menu-list" role="menu" aria-labelledby="menu-btn">
        <a href="<?php echo esc_url(home_url('/')); ?>" role="menuitem">Home</a>
        <a href="<?php echo esc_url(home_url('/booking')); ?>" role="menuitem">Booking</a>
        <a href="https://take5nutrition.com/Personal%20training/" role="menuitem">Personal Training</a>
        <a href="<?php echo esc_url(home_url('/about')); ?>" role="menuitem">About Me</a>
        <a href="<?php echo esc_url(home_url('/contact')); ?>" role="menuitem">Contact</a>
        <a href="<?php echo esc_url(home_url('/blog')); ?>" role="menuitem">Blog</a>

        <hr style="border: none; height: 1px; background-color: #D99F22; margin: 8px 0;">

        <!-- Social Media dropdown -->
        <div class="submenu">
          <button class="submenu-btn" aria-expanded="false">Social Media ▾</button>
          <div class="submenu-content">
            <a href="https://www.instagram.com/take5nutrition/" target="_blank" rel="noopener" role="menuitem">Instagram</a>
            <a href="https://www.youtube.com/@Take5nutrition" target="_blank" rel="noopener" role="menuitem">YouTube</a>
            <a href="https://www.tiktok.com/@take5nutrition" target="_blank" rel="noopener" role="menuitem">TikTok</a>
            <a href="https://www.facebook.com/profile.php?id=61579250283756" target="_blank" rel="noopener" role="menuitem">Facebook</a>
          </div>
        </div>
      </nav>
    </div>
  </div>
</header>

<script>
  (function(){
    const dropdown = document.getElementById('dropdown');
    const menuBtn = document.getElementById('menu-btn');
    menuBtn.addEventListener('click', function(e){
      e.stopPropagation();
      const isExpanded = menuBtn.getAttribute('aria-expanded') === 'true';
      menuBtn.setAttribute('aria-expanded', String(!isExpanded));
      dropdown.classList.toggle('show');
    });
    document.addEventListener('click', function(e){
      if(!dropdown.contains(e.target)) {
        dropdown.classList.remove('show');
        menuBtn.setAttribute('aria-expanded', 'false');
        // Close submenu if open
        const submenu = document.querySelector('.submenu');
        if(submenu) submenu.classList.remove('show');
        const submenuBtn = document.querySelector('.submenu-btn');
        if(submenuBtn) submenuBtn.setAttribute('aria-expanded', 'false');
      }
    });

    // Submenu toggle
    document.addEventListener('DOMContentLoaded', function() {
      const submenuBtn = document.querySelector('.submenu-btn');
      const submenu = document.querySelector('.submenu');

      submenuBtn.addEventListener('click', function(e) {
        e.stopPropagation();
        submenu.classList.toggle('show');
        const isExpanded = submenuBtn.getAttribute('aria-expanded') === 'true';
        submenuBtn.setAttribute('aria-expanded', String(!isExpanded));
      });
    });
  })();
</script>

<?php wp_footer(); ?>
</body>
</html>
