<?php
function take5_enqueue_styles_and_scripts() {
    // Enqueue parent theme style.css
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );

    // Enqueue child theme style.css, dependent on parent-style
    wp_enqueue_style( 'child-style', get_stylesheet_uri(), array('parent-style'), filemtime(get_stylesheet_directory() . '/style.css') );

    // Enqueue dropdown.js script, in footer
    wp_enqueue_script( 'take5-dropdown', get_stylesheet_directory_uri() . '/dropdown.js', array(), null, true );
}
add_action( 'wp_enqueue_scripts', 'take5_enqueue_styles_and_scripts' );
add_action('template_redirect', 'redirect_take5athletics_domain');

add_action('template_redirect', 'take5athletics_virtual_page');

function take5athletics_virtual_page() {
    if ( isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] == 'take5athletics.com' ) {

        // Get the ID of the page with slug 'personal-training'
        $page = get_page_by_path('personal-training');

        if ( $page ) {
            // Load the page template
            global $wp_query;
            $wp_query->init();
            $wp_query->queried_object = $page;
            $wp_query->post = $page;
            $wp_query->posts = array( $page );
            $wp_query->found_posts = 1;
            $wp_query->post_count = 1;
            $wp_query->max_num_pages = 1;
            $wp_query->is_page = true;
            $wp_query->is_singular = true;
            $wp_query->is_home = false;
            $wp_query->is_archive = false;
            $wp_query->is_category = false;
            $wp_query->is_404 = false;

            // Load the WordPress template for a page
            include( get_page_template() );
            exit;
        }
    }
}
