<?php
/**
 * Child Theme Header
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <?php wp_head(); ?>
  <style>
    /* Reset margin/padding and force black header background with only white bottom border */
    header.site-header {
      position: fixed;
      top: 0; left: 0; right: 0;
      background-color: black;
      border-bottom: 1px solid white;
      padding: 15px 30px;
      z-index: 9999;
      display: flex;
      justify-content: center;
      box-shadow: none !important;
      margin: 0 !important;
    }
    .header-inner {
      max-width: 1400px;
      width: 100%;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    .logo img {
      height: 50px;
      transition: height 0.3s ease;
    }
    .dropdown {
      position: relative;
    }
    .menu-btn {
      width: 30px;
      height: 22px;
      background: none;
      border: none;
      cursor: pointer;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      padding: 0;
    }
    .menu-btn span {
      display: block;
      height: 4px;
      width: 30px;
      background-color: white;
      border-radius: 2px;
      transition: all 0.3s ease;
      box-shadow: 0 0 6px 2px rgba(255,255,255,0.7);
    }
    @media (max-width: 480px) {
      .menu-btn {
        width: 35px;
        height: 25px;
      }
      .menu-btn span {
        width: 25px;
        height: 4px;
      }
      .logo img {
        height: 40px;
      }
    }
    .dropdown-content {
      display: none;
      position: absolute;
      right: 0;
      top: 100%;
      margin-top: 10px;
      background-color: black;
      min-width: 140px;
      border: 1px solid #D99F22;
      border-radius: 3px;
      box-shadow: 0 4px 8px rgba(217,159,34,0.3);
      z-index: 10001;
    }
    .dropdown-content a {
      color: #D99F22;
      padding: 10px 14px;
      text-decoration: none;
      display: block;
      font-style: italic;
      font-size: 14px;
    }
    .dropdown-content a:hover {
      background-color: #150F07;
      color: white;
    }
    .dropdown.show .dropdown-content {
      display: block;
    }
    body {
      margin: 0;
      padding-top: 75px; /* offset content so header doesn't cover */
      background-color: white;
    }
  </style>
</head>
<body <?php body_class(); ?>>

<header class="site-header" role="banner">
  <div class="header-inner">
    <a href="<?php echo esc_url(home_url('/')); ?>" class="logo" aria-label="Home">
      <img src="http://take5nutrition.com/wp-content/uploads/2024/12/cropped-cropped-IMG_0815.png" alt="Take 5 Nutrition Logo" />
    </a>
    <div class="dropdown" id="dropdown">
      <button class="menu-btn" aria-haspopup="true" aria-expanded="false" aria-controls="menu-list" id="menu-btn" aria-label="Toggle menu">
        <span></span>
        <span></span>
        <span></span>
      </button>
      <nav class="dropdown-content" id="menu-list" role="menu" aria-labelledby="menu-btn">
        <a href="<?php echo esc_url(home_url('/')); ?>" role="menuitem">Home</a>
        <a href="<?php echo esc_url(home_url('/booking')); ?>" role="menuitem">Booking</a>
        <a href="<?php echo esc_url(home_url('/about')); ?>" role="menuitem">About Me</a>
        <a href="<?php echo esc_url(home_url('/contact')); ?>" role="menuitem">Contact</a>
        <a href="<?php echo esc_url(home_url('/blog')); ?>" role="menuitem">Blog</a>
      </nav>
    </div>
  </div>
</header>

<script>
  (function(){
    const dropdown = document.getElementById('dropdown');
    const menuBtn = document.getElementById('menu-btn');
    menuBtn.addEventListener('click', function(e){
      e.stopPropagation();
      const isExpanded = menuBtn.getAttribute('aria-expanded') === 'true';
      menuBtn.setAttribute('aria-expanded', String(!isExpanded));
      dropdown.classList.toggle('show');
    });
    document.addEventListener('click', function(e){
      if(!dropdown.contains(e.target)) {
        dropdown.classList.remove('show');
        menuBtn.setAttribute('aria-expanded', 'false');
      }
    });
  })();
</script>

<?php wp_footer(); ?>
</body>
</html>
