<?php
function take5_enqueue_styles_and_scripts() {
    // Enqueue parent theme style.css
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );

    // Enqueue child theme style.css, dependent on parent-style
    wp_enqueue_style( 'child-style', get_stylesheet_uri(), array('parent-style'), filemtime(get_stylesheet_directory() . '/style.css') );

    // Enqueue dropdown.js script, in footer
    wp_enqueue_script( 'take5-dropdown', get_stylesheet_directory_uri() . '/dropdown.js', array(), null, true );
}
add_action( 'wp_enqueue_scripts', 'take5_enqueue_styles_and_scripts' );
